/******************************************************************************
 * Technical University of Technology Darmstadt
 * Industrial Process and System Communication
 * Project:  TCP
 * Filename: TCPSynReceived.java
 * Author:   Gunter Weiss
 * Contents: Actions in State Syn_Received of TCP-FSM
 * Last Changes: Gunter Weiss 23/5/97
 *****************************************************************************/
import java.util.Vector;
import java.util.Date;

/******************************************************************************
* Class: TCPSynReceived
* Description: acts corresponding the properties of incoming TCP-Segment
******************************************************************************/
public class TCPSynReceived {

SegArrive parent;
SessionControlBlock newtcb;
int j;

public SessionControlBlock TCPSynReceived( SegArrive home, SessionControlBlock newtcb, int j ) {

    this.parent = home;
    this.newtcb = newtcb;
    this.j = j;

    while(true) {
	      if(parent.segment1.Seqnumb == newtcb.RCVNXT) {
              if(parent.segment1.ACK ==1) {
                newtcb.setack.setAck();
    	        newtcb.TcpStatus = 4;
                parent. tcppro.darfsenden.getrighttosend();
                newtcb.RCVNXT = parent.segment1.Seqnumb +1;
                newtcb.SNDNXT = parent.segment1.Acknumb;
                newtcb.RCVWND = parent.segment1.Wsize;
                newtcb.Dpnumb = parent.segment1.Lpnumb;
                parent. fromnet.removeElementAt(0);
                parent. tcppro.darfsenden.giverighttosend();
                break;
              }
              if(parent.segment1.RST ==1) {
                parent. fromnet.removeElementAt(0);
                newtcb.TcpStatus = 1;
                break;
              }
              if(parent.segment1.SYN ==1) {
                parent. fromnet.removeElementAt(0);
                newtcb.TcpStatus = 0;
                parent. tcb.removeElementAt(j);
        		parent.tcppro.cid--;
                break;
              }
              if(parent.segment1.FIN ==1) {
                parent. fromnet.removeElementAt(0);
                newtcb.TcpStatus = 5;
                break;
              }
          }
          parent. fromnet.removeElementAt(0);

    } //END while(true)
    return newtcb;
} //END methode TCPSynReceived
} //END class TCPSynReceived
